/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.Watchable;
import ibm.nways.jdm.Watcher;
import ibm.nways.jdm.eui.MultiLineLabel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;

class StatusExplain
extends Dialog
implements ActionListener,
Watcher {
    private BrowserApplet browser;
    Status stat;
    private GridBagLayout gbl;
    private Label statLabel;
    private Label statValue;
    private Label explainLabel;
    private Explain explainArea;
    private ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm.StatusExplainResources", Locale.getDefault());
    private Button cancelButton;
    private Button refreshButton;

    public StatusExplain(BrowserApplet browserApplet, Status status) {
        super(browserApplet.getFrame(), false);
        this.browser = browserApplet;
        this.stat = status;
        status.addWatcher(this);
        ((Component)this).setBackground(browserApplet.getBackground());
        this.setForeground(browserApplet.getForeground());
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        I18NString i18NString = status.getName();
        String string = i18NString == null ? this.myResources.getString("noStatusName") : i18NString.getTranslation();
        this.setTitle(String.valueOf(string) + this.myResources.getString("titleTail"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.statLabel = new Label(this.myResources.getString("statLabel"));
        this.statLabel.setForeground(JmaColors.textText);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        this.gbl.setConstraints(this.statLabel, gridBagConstraints);
        this.statValue = new Label();
        this.statValue.setForeground(JmaColors.textText);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 17;
        this.gbl.setConstraints(this.statValue, gridBagConstraints);
        this.explainLabel = new Label(this.myResources.getString("statusExpl"));
        this.explainLabel.setForeground(JmaColors.textText);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.weightx = 1.0;
        this.gbl.setConstraints(this.explainLabel, gridBagConstraints);
        this.explainArea = new Explain("", 10, 10);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.gbl.setConstraints(this.explainArea, gridBagConstraints);
        this.refreshButton = new Button(this.myResources.getString("refreshButton"));
        this.refreshButton.setForeground(SystemColor.controlText);
        this.refreshButton.setBackground(SystemColor.control);
        this.refreshButton.setActionCommand("refreshButton");
        this.refreshButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy += 2;
        gridBagConstraints.gridwidth = 4;
        this.gbl.setConstraints(this.refreshButton, gridBagConstraints);
        this.add(this.refreshButton);
        this.cancelButton = new Button(this.myResources.getString("cancelButton"));
        this.cancelButton.setForeground(SystemColor.controlText);
        this.cancelButton.setBackground(SystemColor.control);
        this.cancelButton.setActionCommand("cancelButton");
        this.cancelButton.addActionListener(this);
        gridBagConstraints.gridx = 5;
        this.gbl.setConstraints(this.cancelButton, gridBagConstraints);
        this.add(this.cancelButton);
        this.addWindowListener(new CloseWindowHandler());
        this.add(this.statLabel);
        this.add(this.statValue);
        this.add(this.explainLabel);
        this.add(this.explainArea);
        this.update();
        this.doLayout();
        ((Component)this).setSize(400, 200);
    }

    public Insets getInsets() {
        return new Insets(40, 20, 20, 20);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("cancelButton")) {
            this.close();
            return;
        }
        if (actionEvent.getActionCommand().equals("refreshButton")) {
            this.stat.check();
        }
    }

    public void close() {
        this.stat.deleteWatcher(this);
        this.dispose();
    }

    public void update(Watchable watchable, Object object) {
        System.out.println("w = " + watchable);
        System.out.println("arg = " + object);
        if (watchable == this.stat) {
            System.out.println("update called ");
            this.update();
        }
    }

    private void update() {
        this.statValue.setText(this.stat.getStatusType().toString());
        String string = null;
        I18NString i18NString = this.stat.getExplanation();
        if (i18NString != null) {
            string = i18NString.getTranslation();
        }
        if (string == null || string.length() == 0) {
            string = this.myResources.getString("noExpl");
        }
        this.explainArea.setText(string);
    }

    private class CloseWindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            StatusExplain.this.close();
        }

        CloseWindowHandler() {
            StatusExplain.this = StatusExplain.this;
        }
    }

    class Explain
    extends MultiLineLabel {
        public Explain(String string, int n, int n2) {
            super(string, n, n2);
            StatusExplain.this = StatusExplain.this;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.max_width, 2 * this.line_height);
        }
    }
}

